/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.ui.containers.views.chests.pagination.layers;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.impactdev.impactor.api.ui.containers.views.pagination.Page;
import net.impactdev.impactor.api.utility.collections.lists.CircularLinkedList;
import net.impactdev.impactor.minecraft.ui.containers.views.chests.pagination.PaginatedView;
import net.impactdev.impactor.minecraft.ui.containers.views.chests.pagination.layers.ImpactorPage;

public class PageManager {
    private final PaginatedView parent;
    private CircularLinkedList<Page> pages;
    private int page = 1;

    public PageManager(PaginatedView parent) {
        this.parent = parent;
        this.pages = this.generatePages();
    }

    public CircularLinkedList<Page> pages() {
        return this.pages;
    }

    public int page() {
        return this.page;
    }

    public void page(int page) {
        this.page = page;
        this.pages.advanceTo(page - 1);
    }

    public void update() {
        this.pages = this.generatePages();
        this.parent.page(Math.min(this.page, this.pages.size()));
    }

    public CircularLinkedList<Page> generatePages() {
        int zone = this.parent.zone().x() * this.parent.zone().y();
        int pages = this.parent.contents().size() / zone + (this.parent.contents().size() % zone == 0 ? 0 : 1);
        List focus = this.parent.ruleset().apply(this.parent.contents().stream()).collect(Collectors.toList());
        CircularLinkedList<Page> results = CircularLinkedList.of(new Page[0]);
        for (int i = 0; i < pages; ++i) {
            ImpactorPage page = ImpactorPage.builder().parent(this.parent).contents(focus.subList(i * zone, Math.min(focus.size(), (i + 1) * zone))).index(i + 1).updaters(this.parent.updaters()).pages(pages).zone(this.parent.zone()).offsets(this.parent.offsets()).build();
            results.append(page);
        }
        if (results.empty()) {
            ImpactorPage page = ImpactorPage.builder().parent(this.parent).contents(Collections.emptyList()).index(1).updaters(this.parent.updaters()).pages(pages).zone(this.parent.zone()).offsets(this.parent.offsets()).build();
            results.append(page);
        }
        return results;
    }
}

